/* -*-C-*-
 #############################################################################
 #
 # File:        diag1432.c
 # RCS:         $Id: diag1432.c,v 1.21 1998/12/04 17:42:34 dhiller Exp $
 # Description: E1432 diagnostics
 # Language:    C
 # Package:     E1430
 # Status:      $State: Exp $
 #
 # Copyright (C) 1995 - 1998, Hewlett-Packard Company, all rights reserved.
 #
 #############################################################################
 #
 # This file contains initialization and utility functions for the tests.
 #############################################################################
*/

#include "sema.h"


const char DOS_FAR e1432_null_str[] = "";

static const char e1432_unxp_str[] = "unexpected SCA";

static const char in32_1_str[] = "E1432 input SCA 1";
static const char in32_2_str[] = "E1432 input SCA 2";
static const char in32_3_str[] = "E1432 input SCA 3";
static const char in32_4_str[] = "E1432 input SCA 4";
const char * DOS_FAR const e1432_in32_str[] =
{ in32_1_str, in32_2_str, in32_3_str, in32_4_str, e1432_unxp_str };

static const char in33a_1_str[] = "E1433A input SCA 1 J2";
static const char in33a_2_str[] = "E1433A input SCA 2 J1";
static const char in33a_3_str[] = "E1433A input SCA 1 J1";
static const char in33a_4_str[] = "E1433A input SCA 2 J2";
const char * DOS_FAR const e1432_in33a_str[] =
{ in33a_1_str, in33a_2_str, in33a_3_str, in33a_4_str, e1432_unxp_str };

static const char in33b_1_str[] = "E1433B input SCA 1 J2";
static const char in33b_2_str[] = "E1433B input SCA 2 J1";
static const char in33b_3_str[] = "E1433B input SCA 1 J1";
static const char in33b_4_str[] = "E1433B input SCA 2 J2";
const char * DOS_FAR const e1432_in33b_str[] =
{ in33b_1_str, in33b_2_str, in33b_3_str, in33b_4_str, e1432_unxp_str };

static const char in1_str[] = "input SCA 1";
static const char in2_str[] = "input SCA 2";
static const char in3_str[] = "input SCA 3";
static const char in4_str[] = "input SCA 4";
const char * DOS_FAR const e1432_in_str[] =
{ in1_str, in2_str, in3_str, in4_str, e1432_unxp_str };

static const char src1_str[] = "E1434 source SCA 1";
static const char src2_str[] = "E1434 source SCA 2";
static const char src_rear_str[] = "option 1D4 source";
const char * DOS_FAR const e1432_src_str[] =
{ src1_str, e1432_unxp_str, src2_str, e1432_unxp_str, src_rear_str };

const char DOS_FAR e1432_tach_str[] = "tach board";

static const char dsp33_0[] = "A";
static const char dsp33_1[] = "B";
const char * DOS_FAR const e1432_dsp33_str[] = {dsp33_0, dsp33_1};

static const char chan32_0[] = "1";
static const char chan32_1[] = "2";
static const char chan32_2[] = "3";
static const char chan32_3[] = "4";
static const char chan32_4[] = "1";
static const char chan32_5[] = "2";
static const char chan32_6[] = "3";
static const char chan32_7[] = "4";
static const char chan32_8[] = "1";
static const char chan32_9[] = "2";
static const char chan32_a[] = "3";
static const char chan32_b[] = "4";
static const char chan32_c[] = "1";
static const char chan32_d[] = "2";
static const char chan32_e[] = "3";
static const char chan32_f[] = "4";
const char * DOS_FAR const e1432_chan32[] =
{   chan32_0, chan32_1, chan32_2, chan32_3,
    chan32_4, chan32_5, chan32_6, chan32_7,
    chan32_8, chan32_9, chan32_a, chan32_b,
    chan32_c, chan32_d, chan32_e, chan32_f
};

static const char chan33_0[] = "1";
static const char chan33_1[] = "2";
static const char chan33_2[] = "3";
static const char chan33_3[] = "4";
static const char chan33_4[] = "1";
static const char chan33_5[] = "2";
static const char chan33_6[] = "3";
static const char chan33_7[] = "4";
const char * DOS_FAR const e1432_chan33[] =
{
    chan33_0, chan33_1, chan33_2, chan33_3,
    chan33_4, chan33_5, chan33_6, chan33_7
};

static const char src_chan_1[] = " channel 1";
static const char src_chan_2[] = " channel 2";
const char * DOS_FAR const e1432_src_chan[] = {src_chan_1, src_chan_2};

const char * DOS_FAR const e1432_no_chan[] = {e1432_null_str, e1432_null_str};

/* channel index to sca slot conversions */
const SHORTSIZ16 DOS_FAR e1432_32chan2sca[] =
{ 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3 };
const SHORTSIZ16 DOS_FAR e1432_33chan2sca[] =
{ 0, 0, 2, 2, 3, 3, 1, 1 };

const SHORTSIZ16 DOS_FAR e1432_fail32[] =
{
    ERR1432_DIAG_ERR_INPUT_SCA0,
    ERR1432_DIAG_ERR_INPUT_SCA1,
    ERR1432_DIAG_ERR_INPUT_SCA2,
    ERR1432_DIAG_ERR_INPUT_SCA3
};
const SHORTSIZ16 DOS_FAR e1432_fail33[] =
{
    ERR1432_DIAG_ERR_INPUT_SCA0,
    ERR1432_DIAG_ERR_INPUT_SCA1,
    ERR1432_DIAG_ERR_INPUT_SCA0,
    ERR1432_DIAG_ERR_INPUT_SCA1
};
const SHORTSIZ16 DOS_FAR e1432_fail_src[] =
{
    ERR1432_DIAG_ERR_SOURCE_SCA0,
    ERR1432_DIAG_ERR_UNDIAGNOSED,
    ERR1432_DIAG_ERR_SOURCE_SCA1,
    ERR1432_DIAG_ERR_UNDIAGNOSED,
    ERR1432_DIAG_ERR_SOURCE_FIT
};


#define MAX_WHEN_LEN 200
void
i1432_print_acc_fail(int level, SHORTSIZ16 err, char *when)
{
    char tmp[MAX_WHEN_LEN + 25];

    if ( ! err ) return;

    if ( strlen(when) > MAX_WHEN_LEN )
    {
	DIAG_PRINTF(level, ("Error %d and \"when\" string too long to print\n"
	  , err))
        return;
    }

    if ( err == ERR1432_BUS_ERROR ){
	(void) sprintf(tmp, "  Bus error while %s.\n", when);
    }
    else
    {
        (void) sprintf(tmp, "  Error %d while %s.\n", err, when);
    }
    DIAG_PRINTF(level, (tmp));
}


void
i1432_r32(E1432_MODULE_LIST_NODE *mn, SHORTSIZ16 *err, LONGSIZ32 addr, 
  LONGSIZ32 *data)
{
    if ( *err ) return;
    *err = i1432_direct_read32_register_a(mn, addr, E1432_A24, data);
}

void
i1432_r32u(E1432_MODULE_LIST_NODE *mn, SHORTSIZ16 *err, LONGSIZ32 addr, 
  ULONGSIZ32 *data)
{
    i1432_r32(mn, err, addr, (LONGSIZ32 *)data);
}

void
i1432_w32(E1432_MODULE_LIST_NODE *mn, SHORTSIZ16 *err, LONGSIZ32 addr, 
  LONGSIZ32 data)
{
    if ( *err ) return;
    *err = i1432_direct_write32_register_a(mn, addr, E1432_A24, data);
}


/*
 *********************************************************************
    Reset the module (other than when hung)
 *********************************************************************
 */
void
i1432_reset_module(E1432_MODULE_LIST_NODE *mn)
{
    DIAG_PRINTF(1, ("  resetting module\n"))
    /* assert reset */
    (void) i1432_direct_write_register(mn, E1432_CONTROL_REG,
      (SHORTSIZ16)0x8003);
    i1432_pause(0.1); 
    /* release reset */
    (void) i1432_direct_write_register(mn, E1432_CONTROL_REG,
      (SHORTSIZ16)0x8002);

    i1432_pause(0.5); 
}


/*
 *********************************************************************

    Recover from a bus error (as in reading an SCA/FIT not present)

 *********************************************************************
 */
void
i1432_berr_recover(E1432_MODULE_LIST_NODE *mn)
{
    long lVal;

    DIAG_PRINTF(1, ("Reseting E143x module.\n"));
    /* assert reset */
    (void) i1432_direct_write_register(mn, E1432_CONTROL_REG,
      (SHORTSIZ16)0x8003);
    i1432_pause(0.1); 
    /* release reset */
    (void) i1432_direct_write_register(mn, E1432_CONTROL_REG,
      (SHORTSIZ16)0x8002);
    
    /* If the E1432 B-bus is hung waiting for TA, it may not
     * un-reset.  Doing a peek seems to help.
     */
    /* help release reset */
    (void) i1432_direct_read32_register_a(mn, 0x10, E1432_A16, &lVal);
#ifdef	__lint
    (void) printf("%ld\n", lVal);
#endif
    /* assert reset */
    (void) i1432_direct_write_register(mn, E1432_CONTROL_REG,
      (SHORTSIZ16)0x8003);
    i1432_pause(0.1); 
    /* release reset */
    (void) i1432_direct_write_register(mn, E1432_CONTROL_REG,
      (SHORTSIZ16)0x8002);
	 
    i1432_pause(0.5); 
}


/* strstr() not available in HPVXI_DOWNLOAD so hard code */
static int
str_present(char *in, char *targ)
{
    int strlen_in = strlen(in);
    int strlen_targ = strlen(targ);
    int itr = strlen_in - strlen_targ;
    char *in_i, *in_ij, *targ_j;
    int i, j;

    in_i = in;
    for ( i =  0; i <= itr; i++ )
    {
	in_ij = in_i++;
	targ_j = targ;
	for ( j = 0; j < strlen_targ && *in_ij++ == *targ_j++ ; j++ );
	if ( j >= strlen_targ ) return 1;
    }

    return 0;
}


/* Return the sca type based on the options string, inst_opts. */
SHORTSIZ16
i1432_sca_type(int sca, char *inst_opts)
{
    if ( inst_opts == NULL || *inst_opts == '\0' ) return E1432_SCA_ID_UNKNOWN;

    if ( sca == E1432_SCA_FIT )
    {
        if ( str_present(inst_opts, "AYF") ) return E1432_SCA_ID_TACH;
        if ( str_present(inst_opts, "1D4") ) return E1432_SCA_ID_CLARINET;
        if ( str_present(inst_opts, "E143") ) return E1432_SCA_ID_NONE;
        return E1432_SCA_ID_UNKNOWN;
    }

    if ( str_present(inst_opts, "1DD") )
    /* 4 channel E1432 */
    {
	if ( sca == 0 ) return E1432_SCA_ID_VIBRATO;
	else return E1432_SCA_ID_NONE;
    }
    if ( str_present(inst_opts, "1DE") )
    /* 8 channel E1432 */
    {
	if ( sca == 0 || sca == 1 ) return E1432_SCA_ID_VIBRATO;
	else return E1432_SCA_ID_NONE;
    }
    if ( str_present(inst_opts, "1DL") )
    /* 4 channel E1433 */
    {
	if ( sca == 0 || sca == 2 )
	{
            /* Take default as E1433A, only E1433B if specified */
	    if ( str_present(inst_opts, "E1433B") )
	    {
	        return E1432_SCA_ID_SONATA_B;
	    }
	    else
	    {
	        return E1432_SCA_ID_SONATA_A;
	    }
	}
	else
	{
	    return E1432_SCA_ID_NONE;
	}
    }
    if ( str_present(inst_opts, "1DM") )
    /* 2 channel Clarion */
    {
	if ( sca == 0 ) return E1432_SCA_ID_CLARION;
	else return E1432_SCA_ID_NONE;
    }

    /* no remove channel options, check product number to see which type
       of SCA */
    if ( str_present(inst_opts, "E1432") ) return E1432_SCA_ID_VIBRATO;
    /* Take E1433 default as "A", only "B" if specified */
    if ( str_present(inst_opts, "E1433B") ) return E1432_SCA_ID_SONATA_B;
    if ( str_present(inst_opts, "E1433") ) return E1432_SCA_ID_SONATA_A;
    if ( str_present(inst_opts, "E1434") )
    {
	if ( sca == 0 || sca == 2 ) return E1432_SCA_ID_CLARION;
	else return E1432_SCA_ID_NONE;
    }

    return E1432_SCA_ID_UNKNOWN;
}


/* Return the DRAM size based on the options string, inst_opts. */
SHORTSIZ16
i1432_dram_size(char *inst_opts)
{
    if ( inst_opts == NULL || strlen(inst_opts) < 3 )
    {
	return E1432_DRAM_UNKNOWN;
    }
    if ( str_present(inst_opts, "ANM") ) return E1432_DRAM_4M;
    if ( str_present(inst_opts, "ANC") ) return E1432_DRAM_32M;
    /* E1434 standard is no DRAM */
    if ( str_present(inst_opts, "E1434") ) return E1432_DRAM_IGNORE;
    return E1432_DRAM_4M;
}
